/* ***************************************************************************+
 * ITX package (cnrg.itx) for telephony application programming.              *
 * Copyright (c) 1999  Cornell University, Ithaca NY.                         *
 * A copy of the license is distributed with this package.  Look in the docs  *
 * directory, filename GPL.  Contact information: bergmark@cs.cornell.edu     *
 ******************************************************************************/


package cnrg.itx.datax.jaudio;

import java.util.*;

public class JAudioIn 
{
	//////////////////////////////////////////////////////////////////////
	//																	//
	//				 CLASS MEMBER VARIABLES								//
	//																	//
	//////////////////////////////////////////////////////////////////////

	protected JAudioDevice device;
	protected Queue blockQueue;

	//////////////////////////////////////////////////////////////////////
	//																	//
	//					  CLASS METHODS									//
	//																	//
	//////////////////////////////////////////////////////////////////////

	//////////////////////////////////////////////////////////////////////
	//
	//	JAudioIn::JAudioIn()
	//
	//	Description:
	//		JAudioIn constructor.
	//	
	//	Parameters:
	//		device:  The JAudioDevice to which this JAudio belongs.
	//
	//	Returns:
	//		Nothing.
	//
	//////////////////////////////////////////////////////////////////////
	protected JAudioIn(JAudioDevice device) 
	{
		this.device = device;
		blockQueue = new Queue();
	}

	//////////////////////////////////////////////////////////////////////
	//
	//	JAudioIn::start() / stop()
	//
	//	Description:
	//		Starts and stops the JAudioIn.
	//	
	//	Parameters:
	//		None.
	//
	//	Returns:
	//		Nothing.
	//
	//////////////////////////////////////////////////////////////////////
	public void start() throws JAudioException 
	{
		startN();
		device.checkError();
	}
	public void stop() throws JAudioException 
	{
		stopN();
		device.checkError();
	}

	//////////////////////////////////////////////////////////////////////
	//
	//	JAudioIn::addBlock()
	//
	//	Description:
	//		Adds a JAudioBlock to the input queue.
	//	
	//	Parameters:
	//		block:	The JAudioBlock to add to the input queue.
	//
	//	Returns:
	//		Nothing.
	//
	//////////////////////////////////////////////////////////////////////
	public void addBlock(JAudioBlock block) throws JAudioException 
	{
		if (!block.grabUsedInLock()) 
		{
			throw new JAudioException("Block is already being used, can't do input");
		}

		// Add the block to the block queue (to keep GC happy) and send 
		// the block to the device
		blockQueue.Push(block);
		addBlockN(block);
		device.checkError();
	}

	//////////////////////////////////////////////////////////////////////
	//																	//
	//					  CLASS HELPER METHODS							//
	//																	//
	//////////////////////////////////////////////////////////////////////

	// All native methods
	private native void startN();
	private native void addBlockN(JAudioBlock b);
	private native void stopN();
}
